﻿using System;
using System.IO;
using System.IO.IsolatedStorage;

namespace Isolated
{
    class Program
    {
        // Listing 11-49. Utworzenie katalogu i pliku w magazynie.
        static void Main(string[] args)
        {
            IsolatedStorageFile store = IsolatedStorageFile.GetUserStoreForAssembly();
            // Utworzenie katalogu — tę operację można bezpiecznie
            // wykonywać wiele razy.
            store.CreateDirectory("Settings");
            // Otworzenie lub utworzenie pliku.
            using (IsolatedStorageFileStream stream = store.OpenFile(
                "Settings\\standardsettings.txt",
                System.IO.FileMode.OpenOrCreate,
                System.IO.FileAccess.ReadWrite))
            {
                UseStream(stream);
            }
            Console.ReadKey();
        }

        // Listing 11-50. Używanie obiektów StreamReader oraz StreamWriter z mechanizmem Isolated Storage.
        static void UseStream(Stream stream)
        {
            if (stream.Length > 0)
            {
                using (StreamReader reader = new StreamReader(stream))
                {
                    Console.WriteLine(reader.ReadToEnd());
                }
            }
            else
            {
                using (StreamWriter writer = new StreamWriter(stream))
                {
                    writer.WriteLine(
                    "Ustawienia zainicjowane o godzinie {0}.", DateTime.Now.TimeOfDay);
                    Console.WriteLine("Ustawienia zostały zainicjowane.");
                }
            }
        }
    }
}
